/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWOperationDefinition;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.event.IVWCoordinationEventListener;
import filenet.vw.toolkit.design.property.event.VWCoordinationEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.steps.IVWPropertyTab;
import filenet.vw.toolkit.design.property.steps.VWOperationParametersPanel;
import filenet.vw.toolkit.design.property.steps.VWSelectParametersPanel;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.VWTitledBorder;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;

class VWGeneralStepParametersTab
extends JPanel
implements IVWPropertyTab,
ActionListener,
IVWPropertyChangeListener,
IVWCoordinationEventListener {
    private VWAuthPropertyData m_authPropertyData = null;
    private VWStepDefinition m_stepDefinition = null;
    private JComboBox m_operationComboBox = null;
    private CardLayout m_cardLayout = null;
    private JPanel m_cardLayoutParentPanel = null;
    private VWSelectParametersPanel m_selectParamPanel = null;
    private VWOperationParametersPanel m_operationParamPanel = null;

    public void init(VWAuthPropertyData authPropertyData, VWMapNode vwMapNode) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.createControls();
            this.setSelectedStep(vwMapNode);
            this.m_authPropertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
            this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().addCoordinationEventListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setSelectedStep(VWMapNode vwMapNode) {
        try {
            if (this.m_stepDefinition != null && this.m_stepDefinition == vwMapNode) {
                return;
            }
            this.reinitialize();
            this.m_stepDefinition = (VWStepDefinition)vwMapNode;
            this.initOperationComboBox();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseReferences() {
        this.m_authPropertyData.getPropertyChangeEventNotifier().removePropertyChangeListener(this);
        this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().removeCoordinationEventListener(this);
        if (this.m_operationComboBox != null) {
            this.m_operationComboBox.removeActionListener(this);
            this.m_operationComboBox.removeAllItems();
            this.m_operationComboBox = null;
        }
        this.m_cardLayout = null;
        if (this.m_cardLayoutParentPanel != null) {
            this.m_cardLayoutParentPanel.removeAll();
            this.m_cardLayoutParentPanel = null;
        }
        if (this.m_selectParamPanel != null) {
            this.m_selectParamPanel.releaseReferences();
            this.m_selectParamPanel = null;
        }
        this.m_operationParamPanel = null;
        this.m_authPropertyData = null;
        this.m_stepDefinition = null;
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource().equals(this.m_operationComboBox)) {
                this.onOperationComboBox();
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        try {
            switch (event.getID()) {
                case 503: 
                case 531: {
                    this.initOperationComboBox();
                    this.m_selectParamPanel.updateUI();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void handleCoordinationEvent(VWCoordinationEvent event) {
        switch (event.getID()) {
            case 757: 
            case 770: 
            case 771: 
            case 772: {
                this.initOperationComboBox();
            }
        }
    }

    protected void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 0.2;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 5, 15);
            this.add((Component)this.getOperationPanel(), gbCons);
            ++gbCons.gridx;
            gbCons.gridy = 0;
            gbCons.fill = 1;
            gbCons.weightx = 0.8;
            gbCons.weighty = 1.0;
            gbCons.gridheight = 0;
            gbCons.insets = new Insets(5, 5, 5, 10);
            this.m_cardLayout = new CardLayout();
            this.m_cardLayoutParentPanel = new JPanel(this.m_cardLayout);
            this.m_selectParamPanel = new VWSelectParametersPanel(this.m_authPropertyData);
            this.m_cardLayoutParentPanel.add((Component)this.m_selectParamPanel, VWResource.s_parametersStr);
            this.m_operationParamPanel = new VWOperationParametersPanel(this.m_authPropertyData);
            this.m_cardLayoutParentPanel.add((Component)this.m_operationParamPanel, VWResource.s_operationParametersStr);
            this.m_operationParamPanel.setVisible(false);
            this.add((Component)this.m_cardLayoutParentPanel, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void reinitialize() {
        this.m_stepDefinition = null;
        this.m_selectParamPanel.reinitialize();
        this.m_operationParamPanel.reinitialize(null, null);
    }

    private JPanel getOperationPanel() {
        JPanel operationPanel = new JPanel(new BorderLayout());
        try {
            operationPanel.setBorder(new VWTitledBorder(VWResource.s_operationStr));
            this.m_operationComboBox = new JComboBox();
            this.m_operationComboBox.setEnabled(false);
            this.m_operationComboBox.setRenderer(new VWLabelListCellRenderer());
            this.m_operationComboBox.addActionListener(this);
            operationPanel.add((Component)this.m_operationComboBox, "First");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return operationPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOperationComboBox() {
        try {
            if (this.m_operationComboBox != null) {
                String queueName;
                this.m_operationComboBox.removeActionListener(this);
                this.m_operationComboBox.removeAllItems();
                this.m_operationComboBox.setEnabled(false);
                if (this.m_stepDefinition != null && (queueName = this.m_stepDefinition.getQueueName()) != null) {
                    VWOperationDefinition[] operationDefs = null;
                    VWQueueDefinition queueDef = this.m_authPropertyData.getDesignerCoreData().getDataDictionary().getQueueDefinition(queueName);
                    if (queueDef != null) {
                        operationDefs = queueDef.getOperations();
                    }
                    boolean bOpNameFound = false;
                    String selectedOpName = this.m_stepDefinition.getOperationName();
                    this.m_operationComboBox.addItem(VWResource.s_noneItemStr);
                    if (operationDefs != null) {
                        for (int nIndex = 0; nIndex < operationDefs.length; ++nIndex) {
                            String opName = operationDefs[nIndex].getName();
                            if (opName == null || opName.length() <= 0) continue;
                            this.m_operationComboBox.addItem(opName);
                            if (selectedOpName == null || VWStringUtils.compare(selectedOpName, opName) != 0) continue;
                            bOpNameFound = true;
                            break;
                        }
                    }
                    if (!bOpNameFound && selectedOpName != null) {
                        this.m_operationComboBox.addItem(selectedOpName);
                    }
                    if (this.m_operationComboBox.getItemCount() > 1) {
                        if (selectedOpName == null) {
                            this.m_operationComboBox.setSelectedItem(VWResource.s_noneItemStr);
                        } else {
                            this.m_operationComboBox.setSelectedItem(selectedOpName);
                        }
                        this.m_operationComboBox.setEnabled(true);
                    }
                }
                this.onOperationComboBox();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            if (this.m_operationComboBox != null) {
                this.m_operationComboBox.addActionListener(this);
            }
        }
    }

    private void onOperationComboBox() {
        try {
            String operationName = (String)this.m_operationComboBox.getSelectedItem();
            if (operationName != null && VWStringUtils.compareIgnoreCase(operationName, VWResource.s_noneItemStr) != 0) {
                VWOperationDefinition[] operationDefs = null;
                VWQueueDefinition queueDef = this.m_authPropertyData.getDesignerCoreData().getDataDictionary().getQueueDefinition(this.m_stepDefinition.getQueueName());
                if (queueDef != null) {
                    operationDefs = queueDef.getOperations();
                }
                if (operationDefs != null) {
                    for (int nIndex = 0; nIndex < operationDefs.length; ++nIndex) {
                        if (VWStringUtils.compare(operationDefs[nIndex].getName(), operationName) != 0) continue;
                        String stepOperationName = this.m_stepDefinition.getOperationName();
                        VWParameterDefinition[] opParamDefs = operationDefs[nIndex].getParameterDefinitions();
                        VWParameterDefinition[] clonedParamDefs = null;
                        if (opParamDefs != null) {
                            clonedParamDefs = new VWParameterDefinition[opParamDefs.length];
                            for (int i = 0; i < clonedParamDefs.length; ++i) {
                                clonedParamDefs[i] = (VWParameterDefinition)opParamDefs[i].clone();
                            }
                            if (stepOperationName != null && VWStringUtils.compare(stepOperationName, operationName) == 0) {
                                String[] parameterValues = this.m_stepDefinition.getOperationParameters();
                                if (parameterValues != null) {
                                    for (int i = 0; i < clonedParamDefs.length; ++i) {
                                        if (i >= parameterValues.length) continue;
                                        clonedParamDefs[i].setValue(parameterValues[i]);
                                    }
                                }
                            } else {
                                this.m_stepDefinition.setOperationName(operationName);
                                this.m_stepDefinition.setOperationParameters(null);
                                VWParameterDefinition[] oldParamDefs = this.m_stepDefinition.getParameterDefinitions();
                                if (oldParamDefs != null) {
                                    for (int i = oldParamDefs.length - 1; i >= 0; --i) {
                                        this.m_stepDefinition.deleteParameter(oldParamDefs[i].getName());
                                    }
                                }
                                String[] paramExpressions = new String[clonedParamDefs.length];
                                for (int i = 0; i < clonedParamDefs.length; ++i) {
                                    String paramName = clonedParamDefs[i].getName();
                                    VWFieldDefinition fieldDef = this.m_authPropertyData.getField(paramName);
                                    if (fieldDef == null || fieldDef.getFieldType() != clonedParamDefs[i].getDataType() || fieldDef.isArray() != clonedParamDefs[i].getIsArray()) continue;
                                    clonedParamDefs[i].setValue(paramName);
                                    paramExpressions[i] = paramName;
                                }
                                this.m_stepDefinition.setOperationParameters(paramExpressions);
                            }
                        }
                        this.m_operationParamPanel.reinitialize(this.m_stepDefinition, clonedParamDefs);
                        this.m_operationParamPanel.setVisible(false);
                        this.m_cardLayout.show(this.m_cardLayoutParentPanel, VWResource.s_operationParametersStr);
                        this.m_cardLayout.show(this.m_cardLayoutParentPanel, VWResource.s_parametersStr);
                        this.m_cardLayout.show(this.m_cardLayoutParentPanel, VWResource.s_operationParametersStr);
                        break;
                    }
                }
            } else {
                this.m_stepDefinition.setOperationName(null);
                this.m_stepDefinition.setOperationParameters(null);
                this.m_operationParamPanel.reinitialize(null, null);
                this.m_selectParamPanel.setVisible(false);
                this.m_selectParamPanel.setSelectedStep(this.m_stepDefinition);
                this.m_cardLayout.show(this.m_cardLayoutParentPanel, VWResource.s_parametersStr);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

